﻿//----------------------PROGRAM KONKURSOWY -----------------------
//--------------------------Jakub Szwarc -------------------------
//--------------------Ciało doskonale czarne ---------------------
//------------ Prezentacja RGB pod względem temperatur -----------
//-----------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Drawing.Drawing2D;


namespace BBody
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        

        public static Color BBodyColor(int TemperatureKelv)
        {//http://www.tannerhelland.com/code/Temperature_to_RGB_Worksheet.ods
            int R, G, B;
            int temperature = TemperatureKelv / 100;

            //6600 kelwinów jest temperaturą przełomową w reprezentacji kolorów ciała doskonale czarnego.
            if (temperature <= 66)
            {
                G = temperature;
                G = (int)(99.4708025861 * Math.Log(G) - 161.1195681661);
                R = 255;
                if (temperature <= 19)
                {
                    B = 0;
                }
                else
                {
                    B = temperature - 10;
                    B = (int)(138.5177312231 * Math.Log(B) - 305.0447927307);
                }
            }
            else
            {
                R = temperature - 60;
                R = (int)(329.698727446 * Math.Pow(R, -0.1332047592));
                G = temperature - 60;
                G = (int)(288.1221695283 * Math.Pow(G, -0.0755148492));
                B = 255;
            }
            //kolor w RGB
            return Color.FromArgb(R, G, B);

        }
        private void Form1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
        {
            // wspolrzedna x,y, wysokosc,szerokosc,iterator i temperatura początkową 1000 kelwinów
            int x=0, y=50, height=5, width = 50,i = 0,temperature = 1000,k=0;
            int n=391,temporary=1000; // n jest to liczba przedziałów zaś temporary to jest wartość tymczasowa czyli wartość
            // co jaką ma być wyświetlana temperatura, jeżeli zwiększymy sobie skok przedziałów i będziemy chcieli sobie
            // zrobić od 1000-40000 k to mozemy zrobic sobie temporary 5000 przez co temperatura będzie wyswietlana co 5000kK
                System.Drawing.Font drawFont = new System.Drawing.Font(
        "Arial", 10);
                System.Drawing.SolidBrush drawBrush = new
        System.Drawing.SolidBrush(System.Drawing.Color.Black);

            //1000-10000 kelwinów
            while (i < n)
            {
                Color updatecolor;
                updatecolor = BBodyColor(temperature);
               
                SolidBrush solidBrush = new SolidBrush(
                updatecolor);
                for (k = 0; k < 10; k++)// pętla do rysowania Stringa (temperatury)
                {
                    if (temperature == temporary)
                    {
                        e.Graphics.DrawString(temperature.ToString(), drawFont, drawBrush, (float)x + 50, (float)y - 10);
                        temporary += 1000;
                    }
                }
               e.Graphics.FillRectangle(solidBrush, new Rectangle(x,y,width,height));
               
               temperature += 100;
               y += 5; // przesunięcie y o 5 namalowanych pixeli
               i++;
                solidBrush.Dispose(); // zwolnienie brusha
            }
drawFont.Dispose();//zwolnienie fonta
            

        }


        private void Form1_Load_1(object sender, EventArgs e)
        {
            this.DoubleBuffered = true;
            this.Paint += new PaintEventHandler(Form1_Paint);
        }

        

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            //od 1000-40000 kelwinow
            int Value;
            Value = trackBar1.Value;
            label2.Text = trackBar1.Value.ToString();
           panel1.BackColor = BBodyColor(Value);
           label4.Text = BBodyColor(Value).ToString(); // zwraca kolor i wyswietla go po najechaniu na panel .
        }

        private void panel1_MouseLeave(object sender, EventArgs e)
        {
            label4.Visible = false;
            
        }

        private void panel1_MouseEnter(object sender, EventArgs e)
        {
            label4.Visible = true;
        }
    }
    /* private void timer1_Tick(object sender, EventArgs e)
    {
     this.Refresh();
    }*/


}
